# Command-line Minecraft Launcher
`minecraft-cli` is a low-overhead Minecraft multi-launcher capable of running almost any Minecraft version, written in POSIX shell.

## Why?
The other options for Minecraft launchers are massive (e.g. MultiMC) and like many other aspects of the modern Minecraft ecosystem, full of fragmentation and pointless forks. Sometimes you just want to play Minecraft. Enter `minecraft-cli`.

## Features
- No Microsoft authentication supported (feature, not a bug)
- Extremely low overhead with few dependencies
- POSIX-compliant; should run in any shell on Linux or UNIX-based systems.
- "Officially" supports all major versions up to 1.20.2; Adding new ones is very easy.

## Targeted platforms
- Linux (all distributions)
- OpenBSD

## Dependencies
* `jq`, `curl` and `nickle` - On Debian, you can install with `sudo apt install jq curl nickle`.
* `uname`, `xargs`, `ls`, `cat`, `tr`, `mkdir`, `tee`, `dirname`, `sha1sum`, `sed`, `basename`, `date`, `xargs` - Listed for good measure, but you should almost certainly have all of these unless you are using an incomplete distribution/operating system.
* A POSIX-compatible shell - If you are on Linux or a UNIX-based operating system, you almost certainly have one.
* A Java runtime - Check with your distribution for installing. On Debian-based systems, the package is usually `default-jre` or `openjdk-<version>-jre`.
* In uncommon situations, a C compiler may be required. See the "On natives" section below for more information.
* Some knowledge of Java and Java arguments in particular is recommended.

## Configuration
- The `user.local` file (will be created at launch if it doesn't exist) stores your player name, Java runtime command and additional arguments such as allocated memory for the JVM.
- The `profiles.local` directory is identical to `profiles`, but we recommend placing your own launch profiles in here to keep them organized.
- The `libraries.local` directory contains additional libraries needed for custom profiles. This is particularly useful for modded Minecraft installations.

## On natives
Minecraft requires native code to run specific to your operating system. From 1.13 onwards, these are automatically downloaded from Mojang's servers in the form of a jar file and you don't need to worry about it\*. Any earlier, and you will need to seek the natives yourself. In particular, you need a library called `liblwjgl.so` (`liblwjgl64.so` works too). Obtaining this library can be tricky, but on Debian you can download the `liblwjgl-java-jni` package and the appropriate library will be under `/usr/lib/jni`. You will want to either copy or symlink this to the natives directory, which will be called `natives-<platform>`, e.g. `natives-linux` on Linux. Some older versions also complain about a missing `libjinput-linux64.so` which may be obtained through the `libjinput-jni` package. Despite errors, Minecraft seems to work find without it either way. As a last resort, you will need to compile the necessary natives from source, which will require a C compiler and is beyond the scope of this document. Also note that natives can be loaded as either a shared object or a jar file. The natives folder is only for shared objects.

\* You still need to worry about it for platforms besides Windows, MacOS and Linux.

## Jar patching
As far as patching jar files is concerned, fully-fledged launchers have their own ways of doing this. In our case, however, you will need to return to the old fashion method of manually inserting the contents into the jar file and possibly deleting META-INF. The recommended way of doing this is with the `jar` program that comes with the JDK. You will find few if any situations where this is necessary.

## Known issues/caveats
* Sound does not work for Release 1.7.\*, a1.0.4 and inf-20100618.
* Narrator is unsupported for all versions that include it, as they require a library (Flite) that Mojang doesn't provide, nor do we.
* Mod loaders work, but we do not currently have official support for any. Documentation will be added later for getting these up and running.
* Downloading versions is slower and less efficient than it should be - this will be fixed in the future.
* On OpenBSD (and possibly other obscure platforms), older versions will need to use a newer LWJGL than what the manifest provides, due to legacy LWJGL libraries having limited platform support. This can be easily worked around but isn't done so automatically at the moment.
